/*
 * Decompiled with CFR 0.152.
 */
package jclass.datasource.treemodel;

import java.io.Serializable;
import java.util.Vector;
import jclass.datasource.treemodel.ForwardTreeIterator;
import jclass.datasource.treemodel.ReverseTreeIterator;
import jclass.datasource.treemodel.TreeIterator;
import jclass.datasource.treemodel.TreeNodeModel;

public class TreeNode
implements TreeNodeModel,
Serializable {
    static final long serialVersionUID = 3954769564281049997L;
    private TreeNodeModel parent;
    private Vector children;
    private Object data;

    public TreeNode() {
        this(null);
    }

    public TreeNode(TreeNodeModel treeNodeModel) {
        this.parent = treeNodeModel;
        this.children = new Vector();
        this.data = this;
    }

    public Vector getChildren() {
        return (Vector)this.children.clone();
    }

    public TreeNodeModel getParent() {
        return this.parent;
    }

    public void setParent(TreeNodeModel treeNodeModel) {
        this.parent = treeNodeModel;
    }

    public TreeIterator getIterator() {
        return new ForwardTreeIterator(this.getFirstChild());
    }

    public TreeIterator getIterator(boolean bl) {
        if (bl) {
            return new ForwardTreeIterator(this.getFirstChild());
        }
        return new ReverseTreeIterator(this.getLastChild());
    }

    public TreeIterator getIterator(TreeNodeModel treeNodeModel) {
        return new ForwardTreeIterator(treeNodeModel);
    }

    public TreeIterator getIterator(TreeNodeModel treeNodeModel, boolean bl) {
        if (bl) {
            return new ForwardTreeIterator(treeNodeModel);
        }
        return new ReverseTreeIterator(treeNodeModel);
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public TreeNodeModel append(TreeNodeModel treeNodeModel) {
        if (treeNodeModel == null) {
            return null;
        }
        this.children.addElement(treeNodeModel);
        treeNodeModel.setParent(this);
        return treeNodeModel;
    }

    public TreeNodeModel insert(TreeNodeModel treeNodeModel, TreeNodeModel treeNodeModel2) {
        if (treeNodeModel == null || treeNodeModel2 == null) {
            return null;
        }
        this.children.insertElementAt(treeNodeModel2, this.children.indexOf(treeNodeModel));
        treeNodeModel2.setParent(this);
        return treeNodeModel2;
    }

    public void remove(TreeNodeModel treeNodeModel) {
        this.children.removeElement(treeNodeModel);
    }

    public void removeChildren() {
        this.children.removeAllElements();
    }

    public TreeNodeModel getPreviousChild(TreeNodeModel treeNodeModel) {
        int n = this.children.indexOf(treeNodeModel);
        if (n < 0) {
            return null;
        }
        if (--n >= 0) {
            return (TreeNodeModel)this.children.elementAt(n);
        }
        return null;
    }

    public TreeNodeModel getNextChild(TreeNodeModel treeNodeModel) {
        int n = this.children.indexOf(treeNodeModel);
        if (n < 0) {
            return null;
        }
        if (++n < this.children.size()) {
            return (TreeNodeModel)this.children.elementAt(n);
        }
        return null;
    }

    public TreeNodeModel getFirstChild() {
        if (this.children.size() > 0) {
            return (TreeNodeModel)this.children.firstElement();
        }
        return null;
    }

    public TreeNodeModel getLastChild() {
        if (this.children.size() > 0) {
            return (TreeNodeModel)this.children.lastElement();
        }
        return null;
    }

    public TreeNodeModel getPreviousSibling() {
        TreeNodeModel treeNodeModel = this.getParent();
        if (treeNodeModel == null) {
            return null;
        }
        return treeNodeModel.getPreviousChild(this);
    }

    public TreeNodeModel getNextSibling() {
        TreeNodeModel treeNodeModel = this.getParent();
        if (treeNodeModel == null) {
            return null;
        }
        return treeNodeModel.getNextChild(this);
    }

    public boolean isChildOf(TreeNodeModel treeNodeModel) {
        TreeNodeModel treeNodeModel2 = this;
        while (treeNodeModel2 != null) {
            if (treeNodeModel2.getParent() == treeNodeModel) {
                return true;
            }
            treeNodeModel2 = treeNodeModel2.getParent();
        }
        return false;
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object object) {
        this.data = object;
    }
}

